/*
//###########################################################################
//
// FILE:    F28069_FLASH_lnk.cmd
//
//###########################################################################
*/

MEMORY
{
PAGE 0 :    /* program space */
   /* BEGIN is used for the "boot to SARAM" bootloader mode   */

   BEGIN       : origin = 0x3F7FF6, length = 0x000002
   RAML0       : origin = 0x008000, length = 0x00C000	 /* RAML0-8 combined for size of .text */
   RESET       : origin = 0x3FFFC0, length = 0x000002

   OTP         : origin = 0x3D7800, length = 0x000400     /* on-chip OTP */
   FLASH_ALL   : origin = 0x3D8000, length = 0x01FF80     /* on-chip FLASH */
   BOOTROM     : origin = 0x3FF3B0, length = 0x000C10
   RAMM1       : origin = 0x000150, length = 0x000100     /* on-chip RAM block M1 to save some temporary functions */
   CSM_RSVD    : origin = 0x3F7F80, length = 0x000076     /* Part of FLASH_ALL.  Program with all 0x0000 when CSM is in use. */
   PASSWORDS   : origin = 0x3F7FF8, length = 0x000008     /* Part of FLASH_ALL.  CSM password locations in FLASH_ALL */

PAGE 1 :    /* data space */

   BOOT_RSVD   : origin = 0x000002, length = 0x00004E     /* Part of M0, BOOT rom will use this for stack */
   RAMM0       : origin = 0x000050, length = 0x0007B0      /* on-chip RAM block M0M1 */
   USB_RAM     : origin = 0x040000, length = 0x000800     /* USB RAM		  */

   FPUTABLES   : origin = 0x3FD860, length = 0x0006A0	 /* FPU Tables in Boot ROM */
   IQTABLES    : origin = 0x3FDF00, length = 0x000B50    /* IQ Math Tables in Boot ROM */
   IQTABLES2   : origin = 0x3FEA50, length = 0x00008C    /* IQ Math Tables in Boot ROM */
   IQTABLES3   : origin = 0x3FEADC, length = 0x0000AA	 /* IQ Math Tables in Boot ROM */
}


SECTIONS
{
   codestart        : > BEGIN,      PAGE = 0
   .text            : > FLASH_ALL,      PAGE = 0	
   copysections     : > FLASH_ALL,      PAGE = 0
   .cinit           : > FLASH_ALL,      PAGE = 0
   .pinit           : > FLASH_ALL,      PAGE = 0
   .switch          : > FLASH_ALL,      PAGE = 0
   .reset           : > RESET,      PAGE = 0, TYPE = DSECT /* not used, */

   .stack           : > RAMM0,      PAGE = 1
   .ebss            : > RAML0,      PAGE = 0
   .econst          : > FLASH_ALL,      PAGE = 0

   ramfuncs         :   LOAD = FLASH_ALL,                /* Used by InitFlash() in SysCtrl.c */ 
                        RUN = RAMM1, 
                        LOAD_START(_RamfuncsLoadStart),
                        LOAD_END(_RamfuncsLoadEnd),
                        RUN_START(_RamfuncsRunStart),
                        PAGE = 0

    /* make some dummy spaces */
   ZeroSp1          :   LOAD = FLASH_ALL,
                        RUN = RAMM1,
                        LOAD_START(_TextLoadStart),
                        LOAD_END(_TextLoadEnd),
                        RUN_START(_TextRunStart),
                        PAGE = 0

   ZeroSp2          :   LOAD = FLASH_ALL,
                        RUN = RAMM1,
                        LOAD_START(_IQfuncsLoadStart),
                        LOAD_END(_IQfuncsLoadEnd),
                        RUN_START(_IQfuncsRunStart),
                        PAGE = 0

   .esysmem         : > RAML0,      PAGE = 0
   csm_rsvd         : > CSM_RSVD,   PAGE = 0
   csmpasswds       : > PASSWORDS,  PAGE = 0

   IQmath           : > FLASH_ALL,  PAGE = 0
   IQmathTables     : > IQTABLES,   PAGE = 1, TYPE = NOLOAD
   
   /* Allocate FPU math areas: */
   FPUmathTables    : > FPUTABLES,  PAGE = 1, TYPE = NOLOAD
   
  /* Uncomment the section below if calling the IQNexp() or IQexp()
      functions from the IQMath.lib library in order to utilize the
      relevant IQ Math table in Boot ROM (This saves space and Boot ROM
      is 1 wait-state). If this section is not uncommented, IQmathTables2
      will be loaded into other memory (SARAM, Flash, etc.) and will take
      up space, but 0 wait-state is possible.
   */
/*  IQmathTables2    : > IQTABLES2, PAGE = 1, TYPE = NOLOAD
   {
      IQmath.lib<IQNexpTable.obj> (IQmathTablesRam)
   }*/
   /* Uncomment the section below if calling the IQNasin() or IQasin()
      functions from the IQMath.lib library in order to utilize the
      relevant IQ Math table in Boot ROM (This saves space and Boot ROM
      is 1 wait-state). If this section is not uncommented, IQmathTables2
      will be loaded into other memory (SARAM, Flash, etc.) and will take
      up space, but 0 wait-state is possible.
   */
/*  IQmathTables3    : > IQTABLES3, PAGE = 1, TYPE = NOLOAD
    {
       IQmath.lib<IQNasinTable.obj> (IQmathTablesRam)
    }*/

}

/*
//===========================================================================
// End of file.
//===========================================================================
*/
